@ECHO OFF

REM --- Copyright (c) 2016-2018 VMware, Inc. All rights reserved.
REM --------------------------------------------------------------------------------------
REM Shell script to setup a Web Client SDK development environment.
REM
REM   1. Copy this script to your vCenter Server for Windows administrator directory
REM   2. Run it. Three files are generated: webclient.properties, store.jks and ds.properties
REM   3. Copy these files to your dev machine at the following locations:
REM      a. webclient.properties
REM         - Mac OS:  /var/lib/vmware/vsphere-client/vsphere-client/
REM         - Windows: C:\ProgramData\VMware\vCenterServer\cfg\vsphere-client\
REM      b. store.jks
REM         - Mac OS:  /var/lib/vmware/vsphere-client/
REM         - Windows: C:\ProgramData\VMware\vCenterServer\cfg\
REM      c. ds.properties
REM         - Mac OS: /var/lib/vmware/vsphere-client/vsphere-client/config/
REM         - Windows: C:\ProgramData\VMware\vCenterServer\cfg\vsphere-client\config\
REM   4. Define the VMWARE_CFG_DIR environment variable pointing to the following location:
REM      - Mac OS:  /var/lib/vmware/vsphere-client/
REM      - Windows: C:\ProgramData\VMware\vCenterServer\cfg\
REM   5. Edit server/configuration/tomcat-server.xml:
REM      - replace compression="on" with compression="off" on <Connector port="9443" ...>
REM   6. (Mac OS only) change keystore.jks. path in webclient.properties to use the Mac path
REM   7. (Mac OS first time only) edit server/configuration/tomcat-server.xml:
REM      - replace keystoreFile="C:/ProgramData/VMware/vCenterServer/cfg/store.jks" with
REM                keystoreFile="/var/lib/vmware/vsphere-client/store.jks"
REM   8. Start/restart the Virgo server on your development machine.
REM      You should be able to connect to vCenter Server for Windows using your local server.
REM      (Check the Virgo log in case of problems)
REM
REM  Repeat these steps for another vCenter Server for Windows or VCSA setup.
REM ---------------------------------------------------------------------------------------

REM Path to javas' keytool
SET KEYTOOL=C:\Program Files\VMware\vCenter Server\jre\bin\keytool.exe

REM Path to vecs binary
SET VECS_CLI=C:\Program Files\VMware\vCenter Server\vmafdd\vecs-cli.exe

REM Path to vmafd binary
SET VMAFD_CLI=C:\Program Files\VMware\vCenter Server\vmafdd\vmafd-cli.exe

REM Trusted certificate store name
SET TRUSTED_STORE="TRUSTED_ROOTS"

REM NGC certificate store name
SET NGC_STORE="vsphere-webclient"

REM NGC certificate alias
SET NGC_ALIAS="vsphere-webclient"

REM Keystore path
SET KEYSTORE=C:/ProgramData/VMware/vCenterServer/cfg/store.jks

REM Keystore Password
SET PASS=vmw@re

REM
REM Generating store.jks file
REM
echo Generating store.jks file...

del /f /q keyfile certfile store.p12 store.jks aliases 2>NUL

"%VECS_CLI%" entry getkey --store %NGC_STORE% --alias %NGC_ALIAS% > keyfile

"%VECS_CLI%" entry getcert --store %NGC_STORE% --alias %NGC_ALIAS% > certfile

openssl pkcs12 -export -in certfile -inkey keyfile -name %NGC_ALIAS% -out store.p12 -password "pass:%PASS%" 2>NUL

"%KEYTOOL%" -importkeystore -srckeystore store.p12 --srcstoretype PKCS12 -srcstorepass %PASS% -destkeystore store.jks -deststorepass %PASS% 2>NUL

"%VECS_CLI%" entry list --store TRUSTED_ROOTS | findstr /r /c:"Alias.:.*" > aliases

for /F "usebackq tokens=3" %%F in (`type aliases`) do "%VECS_CLI%" entry getcert --store %TRUSTED_STORE% --alias %%F > %%F.cert
for /F "usebackq tokens=3" %%F in (`type aliases`) do "%KEYTOOL%" -importcert -keystore store.jks -storepass %PASS% -trustcacerts -noprompt -alias %%F -file %%F.cert 2>NUL
for /F "usebackq tokens=3" %%F in (`type aliases`) do del /f /q %%F.cert 2>NUL

del /f /q keyfile certfile store.p12 aliases 2>NUL

REM
REM Generating the webclient.properties file
REM
echo Generating webclient.properties file...

SET PROPFILE=webclient.properties
del /f /q %PROPFILE% 2>NUL

"%KEYTOOL%" -printcert -sslserver localhost | findstr /r /c:"DNSName: .*" > dnsname 2>NUL
SET DNSNAME=
for /f "useback tokens=2" %%F in (`type dnsname`) do SET DNSNAME=%%F
del /f /q dnsname 2>NUL
if "%DNSNAME%" == "" (
  echo ERROR: DNS name not found! You will need to fix cm.url in webclient.properties
  set DNSNAME=MISSING_DNS_NAME
)
FOR /F "tokens=* USEBACKQ" %%F IN (`"%VMAFD_CLI%" get-ls-location --server-name localhost`) DO (
SET LSURL=%%F
)
if "%LSURL%" == "" (
  echo ERROR: LS url not found! You will need to fix ls.url in webclient.properties
  set LSURL=MISSING_LS_URL
)

echo # >> %PROPFILE%
echo # Generated webclient.properties for dev environments. >> %PROPFILE%
echo # Copy this file to the right location along with the generated store.jks (see path below). >> %PROPFILE%
echo # >> %PROPFILE%
echo # The keystore and cm.url settings allow to connect your local Web Client server to your VCSA >> %PROPFILE%
echo # or vCenter for Windows. For additional properties see the content of webclient.properties >> %PROPFILE%
echo # in /etc/vmware/vsphere-client or C:\ProgramData\VMware\vCenterServer\cfg\vsphere-client\ >> %PROPFILE%
echo # >> %PROPFILE%
echo # Do not change. >> %PROPFILE%
echo afd.disabled=true >> %PROPFILE%
echo # >> %PROPFILE%
echo keystore.jks.password=%PASS% >> %PROPFILE%
echo # >> %PROPFILE%
echo # Set the correct value of keystore.jks.path based on your dev OS. >> %PROPFILE%
echo # Mac OS: /var/lib/vmware/vsphere-client/store.jks >> %PROPFILE%
echo # Windows: C:/ProgramData/VMware/vCenterServer/cfg/store.jks >> %PROPFILE%
echo keystore.jks.path=%KEYSTORE% >> %PROPFILE%
echo # >> %PROPFILE%
if "%DNSNAME%" == "MISSING_DNS_NAME" (
   echo # Use "nslookup <IP>" to find the correct DSN name of the vCenter Server host and replace it here. >> %PROPFILE%
) else (
   echo # ComponentManager url with the DNS name of your vCenter Server for Windows host. >> %PROPFILE%
)
echo cm.url=https://%DNSNAME%/cm/sdk/ >> %PROPFILE%
echo ls.url=%LSURL% >> %PROPFILE%
echo # >> %PROPFILE%
echo # Other useful webclient.properties flags for a local dev setup >> %PROPFILE%
echo show.allusers.tasks=true >> %PROPFILE%
echo large.inventory.mode=true >> %PROPFILE%
echo aggregationThreshold.VirtualMachine=100 >> %PROPFILE%
echo local.development=true >> %PROPFILE%

REM
REM Creating ds.properties file
REM
echo Creating ds.properties file...
SET CLIENT_DIR=C:\ProgramData\VMware\vCenterServer\cfg\vsphere-client
SET DS_PROPFILE=ds.properties

ipconfig | findstr "Address" > ipaddr 2>NUL
SET IP_ADDRESS=
for /f "usebackq delims=: tokens=2" %%i in (`type ipaddr`) do set IP_ADDRESS=%%i
del /f /q ipaddr 2>NUL
if "%IP_ADDRESS%" == "" (
  echo ERROR: IP address not found! You will need to fix lookupService in ds.properties
  set IP_ADDRESS=MISSING_IP_ADDRESS
) else (
  set IP_ADDRESS=%IP_ADDRESS: =%
)

copy /Y %CLIENT_DIR%\config\%DS_PROPFILE% .
echo solutionUser.keyStorePath=%KEYSTORE% >> %DS_PROPFILE%
echo solutionUser.keyStorePassword=%PASS% >> %DS_PROPFILE%
echo lookupService=https://%IP_ADDRESS%/lookupservice/sdk >> %DS_PROPFILE%

echo Done.
